<?php
/**
 * Application Configuration
 * Core application settings
 */

return [
    // Application
    'app_name' => 'Advanced SMM Panel',
    'app_url' => 'https://yourdomain.com',
    'app_env' => 'production', // development, staging, production
    'app_debug' => false,
    
    // Security
    'encryption_key' => 'CHANGE_THIS_TO_RANDOM_32_CHARACTER_STRING',
    'session_lifetime' => 7200, // 2 hours in seconds
    'session_name' => 'smm_session',
    'csrf_token_name' => 'csrf_token',
    
    // Timezone
    'timezone' => 'UTC',
    
    // Paths
    'base_path' => dirname(__DIR__),
    'app_path' => dirname(__DIR__) . '/app',
    'public_path' => dirname(__DIR__) . '/public',
    'storage_path' => dirname(__DIR__) . '/storage',
    'views_path' => dirname(__DIR__) . '/app/views',
    
    // Currency
    'default_currency' => 'USD',
    'currency_symbol' => '$',
    
    // Pagination
    'per_page' => 20,
    
    // Auto-topup
    'auto_topup_enabled' => true,
    'auto_topup_session_timeout' => 30, // minutes
    
    // Email (SMTP)
    'smtp_host' => 'smtp.gmail.com',
    'smtp_port' => 587,
    'smtp_username' => 'your-email@gmail.com',
    'smtp_password' => 'your-password',
    'smtp_encryption' => 'tls',
    'smtp_from_email' => 'noreply@yourdomain.com',
    'smtp_from_name' => 'Advanced SMM Panel',
    
    // API
    'api_rate_limit' => 60, // requests per minute
    
    // Referral
    'referral_commission_rate' => 5.0, // percentage
    
    // File uploads
    'max_upload_size' => 5242880, // 5MB in bytes
    'allowed_extensions' => ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx'],
];
